//
//  TWCollectionViewCell.m
//  Twitch
//
//  Created by Auston Stewart on 10/29/13.
//  Copyright (c) 2013 Justin.tv. All rights reserved.
//

#import "TWCollectionViewCell.h"

@implementation TWCollectionViewCell

+ (CGSize)cellSize
{
	// Override in subclasses
	return CGSizeZero;
}

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        UIImageView *imageView = [[UIImageView alloc] init];
		imageView.contentMode = UIViewContentModeScaleAspectFill;
		imageView.clipsToBounds = YES;
		self.backgroundView = imageView;
		_shouldDownloadRedirectedImages = YES;
    }
    return self;
}

- (void)dealloc {
    
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void) prepareForReuse {
	[super prepareForReuse];
	
	if (self.imageURL) {
		self.imageURL = nil;
		[[NSNotificationCenter defaultCenter] removeObserver:self];
	}
	((UIImageView *)self.backgroundView).image = nil;
}

- (void)setImage:(UIImage *)image animated:(BOOL)animated
{
	[UIView transitionWithView:self.backgroundView
					  duration:animated ? .25 : 0.
					   options:(UIViewAnimationOptions)(UIViewAnimationOptionTransitionCrossDissolve | UIViewAnimationOptionBeginFromCurrentState)
					animations:^{
						((UIImageView *)self.backgroundView).image = image;
					} completion:nil];
}

- (void)cacheDidNotDownloadResource:(NSNotification *)notification
{
	if (self.imageURL && [[[notification userInfo] objectForKey:@"key"] isEqualToString:self.imageURL]) {
		
        [[NSNotificationCenter defaultCenter] removeObserver:self];
        self.imageURL = nil;
    }
}

- (void)cacheDidDownloadResource:(NSNotification *)notification
{
    if (self.imageURL && [[[notification userInfo] objectForKey:@"key"] isEqualToString:self.imageURL]) {
        
		[self setImage:[[notification userInfo] objectForKey:@"object"] animated:YES];
		
        [[NSNotificationCenter defaultCenter] removeObserver:self];
        self.imageURL = nil;
    }
}

- (void)loadImageAtURL:(NSString *)url fromCache:(TWCache *)cache persistently:(BOOL)persistently {
    
	UIImage *image = nil;
	
	if (self.imageURL) [[NSNotificationCenter defaultCenter] removeObserver:self];
	self.imageURL = nil;
	
    if (url) image = [cache imageAtURL:url persistently:persistently downloadIfRedirected:_shouldDownloadRedirectedImages];
	
    if (!image) {
        
		if (url) {
			
			[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(cacheDidDownloadResource:) name:TWCacheDidDownloadObject object:cache];
			[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(cacheDidNotDownloadResource:) name:TWCacheDidNotDownloadObject object:cache];
		}
		self.imageURL = url;
		
		if (_placeholderImageName) image = [UIImage imageFromFrameworkBundleNamed:_placeholderImageName];
    }
	
	[self setImage:image animated:NO];
}

@end
